function [wl,im] = hiscale_importRI(filename, startRow, endRow)
%IMPORTFILE Import numeric data from a text file as column vectors.
%   [WL,IM] = IMPORTFILE(FILENAME) Reads data from text file FILENAME for
%   the default selection.
%
%   [WL,IM] = IMPORTFILE(FILENAME, STARTROW, ENDROW) Reads data from rows
%   STARTROW through ENDROW of text file FILENAME.
%
% Example:
%   [wl,im] = importfile('sharpened k veghte.txt',2, 1160);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2019/05/06 14:35:53

%% Initialize variables.
delimiter = ',';
if nargin<=2
	startRow = 2;
	endRow = inf;
end

%% Format for each line of text:
%   column1: double (%f)
%	column2: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%f%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to the format.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'TextType', 'string', 'HeaderLines', startRow(1)-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
for block=2:length(startRow)
	frewind(fileID);
	dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'TextType', 'string', 'HeaderLines', startRow(block)-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
	for col=1:length(dataArray)
		dataArray{col} = [dataArray{col};dataArrayBlock{col}];
	end
end

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Allocate imported array to column variable names
wl = dataArray{:, 1};
im = dataArray{:, 2};


